/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.FactionOption;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;

public class FactionOptions {
    public final List<FactionOption> fps = new ArrayList<FactionOption>();

    public void addPoints(EntityPlayer player) {
        PlayerData playerdata = PlayerData.get(player);
        PlayerFactionData data = playerdata.factionData;
        for (FactionOption fo : this.fps) {
            if (fo.factionId < 0 || fo.factionPoints == 0) continue;
            int value = fo.factionPoints;
            boolean take = fo.decreaseFactionPoints;
            if (value < 0) {
                value *= -1;
                take = !take;
            }
            this.addPoints(player, data, fo.factionId, take, value);
        }
    }

    private void addPoints(EntityPlayer player, PlayerFactionData data, int factionId, boolean decrease, int points) {
        Faction faction = FactionController.instance.getFaction(factionId);
        if (faction == null) {
            return;
        }
        if (!faction.hideFaction) {
            String message = decrease ? "faction.decreasepoints" : "faction.increasepoints";
            player.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[]{faction.name, points}));
        }
        data.increasePoints(player, factionId, decrease ? -points : points);
        PlayerData.get((EntityPlayer)player).updateClient = true;
    }

    public FactionOptions copy() {
        FactionOptions fp = new FactionOptions();
        fp.load(this.save(new NBTTagCompound()));
        return fp;
    }

    public FactionOption get(int factionID) {
        for (FactionOption fo : this.fps) {
            if (fo.factionId != factionID) continue;
            return fo;
        }
        return null;
    }

    public boolean hasFaction(int id) {
        for (FactionOption fo : this.fps) {
            if (fo.factionId != id) continue;
            return true;
        }
        return false;
    }

    public boolean hasOptions() {
        for (FactionOption fo : this.fps) {
            if (fo.factionId <= 0 || fo.factionPoints == 0) continue;
            return true;
        }
        return false;
    }

    public void load(NBTTagCompound compound) {
        this.fps.clear();
        if (!compound.func_150297_b("FactionOptions", 9)) {
            if (compound.func_74762_e("OptionFactions1") > 0) {
                this.fps.add(new FactionOption(compound.func_74762_e("OptionFactions1"), compound.func_74762_e("OptionFaction1Points"), compound.func_74767_n("DecreaseFaction1Points")));
            }
            if (compound.func_74762_e("OptionFactions2") > 0) {
                this.fps.add(new FactionOption(compound.func_74762_e("OptionFactions2"), compound.func_74762_e("OptionFaction2Points"), compound.func_74767_n("DecreaseFaction2Points")));
            }
        } else {
            for (int i = 0; i < compound.func_150295_c("FactionOptions", 10).func_74745_c(); ++i) {
                this.fps.add(new FactionOption(compound.func_150295_c("FactionOptions", 10).func_150305_b(i)));
            }
        }
    }

    public boolean remove(int factionID) {
        for (FactionOption fo : this.fps) {
            if (fo.factionId != factionID) continue;
            this.fps.remove(fo);
            return true;
        }
        return false;
    }

    public NBTTagCompound save(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (FactionOption fo : this.fps) {
            list.func_74742_a((NBTBase)fo.writeToNBT());
        }
        compound.func_74782_a("FactionOptions", (NBTBase)list);
        return compound;
    }
}

